package gov.va.med.mhv.sm.web.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import gov.va.med.mhv.sm.dto.CPRSMessageStatusDTO;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.service.TiuNoteService;
import gov.va.med.mhv.sm.util.CPRSMessageUtils;

public class ViewCPRSProgressNotesAlerts extends BaseSMAdminAction {

	private static final long serialVersionUID = 6822477122257702738L;

	protected static final String CPRSALERTS_VISN_ATTR_NAME = "SMCLINICS_VISN_ATTR_NAME";
	protected static final String CPRSALERTS_FACILITY_ATTR_NAME = "SMCLINICS_FACILITY_ATTR_NAME";
	public static final String SORT_COLUMN ="SortColumn";
	public static final String SORT_ORDER = "SortOrder";
	private TiuNoteService tiuNoteService;
	private Collection<CPRSMessageStatusDTO> cprsFailedList; 
	private String sortColumn;
	private String sortOrder;
	
	private static final Log log = LogFactory.getLog(ViewCPRSProgressNotesAlerts.class);
	

	public void prepare() throws Exception {
		WebApplicationContext ctx = WebApplicationContextUtils
		.getWebApplicationContext(ServletActionContext.getServletContext());
		tiuNoteService = (TiuNoteService) ctx.getBean("tiuNoteService");
	}
	
	public String start() {
		this.setSessionAttribute(CPRSALERTS_VISN_ATTR_NAME, null);
		this.setSessionAttribute(CPRSALERTS_FACILITY_ATTR_NAME, null);
		return SUCCESS;
	}
	
	public String chooseVisn() 
	{
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		Long newVisnId = getParameterAsLong("visnId");
		Facility oldVisn = (Facility)getSessionAttribute(CPRSALERTS_VISN_ATTR_NAME);
		return SUCCESS;
	}
	
	protected boolean cancelButtonPressed() {
		return ! StringUtils.isBlank(getParameter("[CANCEL BUTTON]"));
	}

	public Facility getVisn() {
		Facility visn = (Facility)getSessionAttribute(CPRSALERTS_VISN_ATTR_NAME);
		if ( visn == null && ! getShowAdministeredVisnList() ) {
			visn = getAdministeredVisns().iterator().next();
			this.setSessionAttribute(CPRSALERTS_VISN_ATTR_NAME, visn);
		}
		return visn;
	}

	public boolean getShowAdministeredVisnList() {
		boolean result = getAdministeredVisns().size() > 1;
		return result;
	}

	public Collection<Facility> getAdministeredFacilitiesInVisn() {
		if ( this.getVisnId() == null ) {
			return new TreeSet<Facility>();
		} else {
			return getAdministeredFacilitiesInVisn(getVisn());
		}
	}
	
	public Long getVisnId() {
		Facility visn = getVisn();
		if ( visn != null ) {
			return visn.getId();
		} else {
			return null;
		}
	}
	
	public Long getFacilityId() {
		Facility f = getFacility();
		if ( f != null ) {
			return f.getId();
		} else {
			return null;
		}
	}
	
	public Facility getFacility() {
		Facility f = (Facility)getSessionAttribute(CPRSALERTS_FACILITY_ATTR_NAME);
		if ( f == null && ! this.getShowAdministeredFacilityList() ) {
			f = this.getAdministeredFacilitiesInVisn().iterator().next();
			this.setSessionAttribute(CPRSALERTS_FACILITY_ATTR_NAME, f);
		}
		return f;
	}
	
	public boolean getShowAdministeredFacilityList() {
		boolean result = this.getAdministeredFacilitiesInVisn().size() > 1
			|| (getCurrentUser().isNational());
		return result;
	}

	public String chooseFacility() {
		
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		Long newId = getParameterAsLong("newFacilityId");
		Long oldId = getFacilityId();
		if ( oldId != null && ! oldId.equals(newId) ) {
			//clearMembersAndRelations();
		}
		setFacilityId(newId);
		setCprsFailedList(getCPRSFailedStatusList(getFacility().getStationNumber()));
		setSessionAttribute(SORT_COLUMN, "ALERT_DATE");
		setSessionAttribute(SORT_ORDER,"DESC");
		return SUCCESS;
	}
	
	public String sort(){
		List<CPRSMessageStatusDTO> failedCPRSMessages =  (ArrayList)getCPRSFailedStatusList(getFacility().getStationNumber());
		Locale.setDefault(Locale.ENGLISH);
		if(getSortColumn().equals("errorCode")){
			if(getSessionAttribute(SORT_ORDER).equals("ASC")){
				Collections.sort(failedCPRSMessages,ErrorCODE_SORTER);
			}else{
				Collections.sort(failedCPRSMessages,ErrorCODE_SORTER);
				Collections.reverse(failedCPRSMessages);
			}
			setCprsFailedList(failedCPRSMessages);
		}
		
		if(getSortColumn().equals("savedBy")){
			if(getSessionAttribute(SORT_ORDER).equals("ASC")){
				Collections.sort(failedCPRSMessages,NAME_SORTER);
			}else{
				Collections.sort(failedCPRSMessages,NAME_SORTER);
				Collections.reverse(failedCPRSMessages);
			}
			setCprsFailedList(failedCPRSMessages);
		}
		if(getSortColumn().equals("triageGroup")){
			if(getSessionAttribute(SORT_ORDER).equals("ASC")){
				Collections.sort(failedCPRSMessages,TRIAGE_GROUP_SORTER);
			}else{
				Collections.sort(failedCPRSMessages,TRIAGE_GROUP_SORTER);
				Collections.reverse(failedCPRSMessages);
			}
			setCprsFailedList(failedCPRSMessages);
		}
		if(getSortColumn().equals("messageId")){
			if(getSessionAttribute(SORT_ORDER).equals("ASC")){
				Collections.sort(failedCPRSMessages,MESSAGE_SORTER);
			}else{
				Collections.sort(failedCPRSMessages,MESSAGE_SORTER);
				Collections.reverse(failedCPRSMessages);
			}
			setCprsFailedList(failedCPRSMessages);
		}
		if(getSortColumn().equals("dateSaved")){
			if(getSessionAttribute(SORT_ORDER).equals("ASC")){
				Collections.sort(failedCPRSMessages,DATE_SORTER);
			}else{
				Collections.sort(failedCPRSMessages,DATE_SORTER);
				Collections.reverse(failedCPRSMessages);
			}
			setCprsFailedList(failedCPRSMessages);
		}
		
		setSessionAttribute(SORT_COLUMN, getSortColumn());		
		if(getSessionAttribute(SORT_ORDER).equals("ASC")){
				setSessionAttribute(SORT_ORDER, "DESC");
		}else{
				setSessionAttribute(SORT_ORDER, "ASC");
		}
		return SUCCESS;
	}
	
	public Collection<CPRSMessageStatusDTO>  sortCPRSAlerts(String orderBy, String order){
		
		return getCPRSFailedStatusList(getFacility().getStationNumber());
	}
	
	
	public Collection<CPRSMessageStatusDTO> getCPRSFailedStatusList(String stationNumber){
		List<Object[]> listObj = tiuNoteService.getFailedCPRSProgressNotesByStation(stationNumber);
		Collection<CPRSMessageStatusDTO> cprsFailedList = CPRSMessageUtils.getFailedCPRSMessages(listObj);
		return cprsFailedList;
	}
	
	
	
	
	public static final Comparator<CPRSMessageStatusDTO> ErrorCODE_SORTER = new Comparator<CPRSMessageStatusDTO>() {
		public int compare(CPRSMessageStatusDTO a, CPRSMessageStatusDTO b) {
			if(a == null || b == null) return 0;
			int result = (a.getErrorCode().toUpperCase()).compareTo(b.getErrorCode().toUpperCase());
			if ( result == 0 ) {
				result = a.getErrorCode().toUpperCase().compareTo(b.getErrorCode().toUpperCase());
			}
			return result;
		}
	};
	
	public static final Comparator<CPRSMessageStatusDTO> NAME_SORTER = new Comparator<CPRSMessageStatusDTO>() {
		public int compare(CPRSMessageStatusDTO a, CPRSMessageStatusDTO b) {
			if(a == null || b == null) return 0;
			int result = (a.getLastName().toUpperCase()).compareTo(b.getLastName().toUpperCase());
			if ( result == 0 ) {
				result = a.getLastName().toUpperCase().compareTo(b.getLastName().toUpperCase());
			}
			return result;
		}
	};
	
	public static final Comparator<CPRSMessageStatusDTO> TRIAGE_GROUP_SORTER = new Comparator<CPRSMessageStatusDTO>() {
		public int compare(CPRSMessageStatusDTO a, CPRSMessageStatusDTO b) {
			if(a == null || b == null) return 0;
			return a.getTriageGroupName().toUpperCase().compareTo(b.getTriageGroupName().toUpperCase());
		}
	};
	
	public static final Comparator<CPRSMessageStatusDTO> MESSAGE_SORTER = new Comparator<CPRSMessageStatusDTO>() {
		public int compare(CPRSMessageStatusDTO a, CPRSMessageStatusDTO b) {
			if(a == null || b == null) return 0;
			return a.getMessageId().compareTo(b.getMessageId().toUpperCase());
		}
	};
	
	public static final Comparator<CPRSMessageStatusDTO> DATE_SORTER = new Comparator<CPRSMessageStatusDTO>() {
		public int compare(CPRSMessageStatusDTO a, CPRSMessageStatusDTO b) {
			if(a == null || b == null) return 0;
			return a.getCreatedDate().compareTo(b.getCreatedDate());
		}
	};
	
	public void setFacilityId(Long facilityId) {
		setFacility(getFacilityService().getFacility(facilityId).getPayload());
	}
	
	public void setFacility(Facility facility) {
		this.setSessionAttribute(CPRSALERTS_FACILITY_ATTR_NAME, facility);
	}
	
	
	public String goBack() {
		String step = getParameter("step");
		if ( ! StringUtils.isBlank(step) ) {
			return "STEP" + step;
		} else {
			return "STEP1";
		}
	}
	
	public void setVisnId(Long visnId) {
		setSessionAttribute(CPRSALERTS_VISN_ATTR_NAME, getFacilityService().getFacility(visnId).getPayload());
	}
	
	public Collection<CPRSMessageStatusDTO> getCprsFailedList() {
		return cprsFailedList;
	}

	public void setCprsFailedList(Collection<CPRSMessageStatusDTO> cprsFailedList) {
		this.cprsFailedList = cprsFailedList;
	}
	
	public String getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(String sortColumn) {
		this.sortColumn = sortColumn;
	}

	public String getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(String sortOrder) {
		this.sortOrder = sortOrder;
	}


}
